
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams_of_vitamin_B1", vtype=gp.GRB.INTEGER)  # integer
x2 = m.addVar(name="grams_of_protein")  # continuous, but consider as non-fractional
x3 = m.addVar(name="grams_of_fiber")  # continuous

# Objective function
m.setObjective(7*x1**2 + 9*x1*x2 + 4*x1*x3 + 4*x2**2 + 8*x2*x3 + x3**2 + 8*x1 + 4*x2 + x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(x1 <= 10.333333333333334)
m.addConstr(x2 <= 13.285714285714286)
m.addConstr(x3 <= 9.3)
m.addConstr(9*x1 + 10*x3 >= 16)
m.addConstr(9*x1 + 7*x2 >= 19)
m.addConstr(9*x1 + 7*x2 + 10*x3 >= 19)
m.addConstr(81*x1**2 + 49*x2**2 + 100*x3**2 <= 73)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"x1: {x1.varValue}")
    print(f"x2: {x2.varValue}")
    print(f"x3: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
