
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="vitamin_c") # milligrams of vitamin C (integer)
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b4") # milligrams of vitamin B4

    # Set objective function
    m.setObjective(2.04 * x0 + 8.38 * x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(0.24 * x0 + 0.73 * x1 >= 20, "immune_support_min")
    m.addConstr(0.03 * x0 + 0.9 * x1 >= 27, "kidney_support_min")
    m.addConstr(4 * x0 - 2 * x1 >= 0, "vitamin_ratio")
    m.addConstr(0.24 * x0 + 0.73 * x1 <= 36, "immune_support_max")
    m.addConstr(0.03 * x0 + 0.9 * x1 <= 51, "kidney_support_max")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Milligrams of Vitamin C: {x0.x}")
        print(f"Milligrams of Vitamin B4: {x1.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
