
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="x1")  # milligrams of vitamin C
    x2 = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin B4

    # Define the objective function
    model.setObjective(2.04 * x1 + 8.38 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.24 * x1 + 0.73 * x2 >= 20, name="immune_support_index_min")
    model.addConstr(0.03 * x1 + 0.9 * x2 >= 27, name="kidney_support_index_min")
    model.addConstr(4 * x1 - 2 * x2 >= 0, name="vitamin_constraint")
    model.addConstr(0.24 * x1 + 0.73 * x2 <= 36, name="immune_support_index_max")
    model.addConstr(0.03 * x1 + 0.9 * x2 <= 51, name="kidney_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin C: {x1.varValue}")
        print(f"Milligrams of vitamin B4: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
