
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_D")
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_B4")
    x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_B12")

    # Set objective function
    m.setObjective(4*x0**2 + 7*x0*x1 + 5*x1*x2 + 9*x0 + 6*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*x0 + 6*x1 >= 4, "c1")
    m.addConstr(8*x0 + 6*x1 + 4*x2 >= 5, "c2")
    m.addConstr(8*x0 + 4*x2 <= 27, "c3")
    m.addConstr(8*x0 + 6*x1 <= 17, "c4")
    m.addConstr(6*x1 + 4*x2 <= 21, "c5")
    m.addConstr(8*x0 + 6*x1 + 4*x2 <= 21, "c6")
    m.addConstr(3*x0 + 2*x1 <= 15, "c7")
    m.addConstr(3*x0 + 7*x2 <= 22, "c8")
    m.addConstr(3*x0 + 2*x1 + 7*x2 <= 22, "c9")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_D: %g' % x0.x)
        print('vitamin_B4: %g' % x1.x)
        print('vitamin_B12: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

