
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    strips_of_bacon = m.addVar(vtype=GRB.INTEGER, name="strips_of_bacon")
    oranges = m.addVar(vtype=GRB.CONTINUOUS, name="oranges")

    # Set objective function
    m.setObjective(1.28*strips_of_bacon**2 + 3.91*oranges**2 + 8.56*strips_of_bacon + 5.2*oranges, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*strips_of_bacon + 3*oranges >= 14, "fiber_minimum")
    m.addConstr(4*strips_of_bacon - 6*oranges >= 0, "bacon_orange_ratio")
    m.addConstr(8*strips_of_bacon**2 + 3*oranges**2 <= 15, "fiber_squared_limit")
    m.addConstr(8*strips_of_bacon + 3*oranges <= 15, "fiber_limit")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('strips_of_bacon: %g' % strips_of_bacon.x)
        print('oranges: %g' % oranges.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

