
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="strips_of_bacon")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="oranges")

# Define the objective function
m.setObjective(1.28*x1**2 + 3.91*x2**2 + 8.56*x1 + 5.2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x1 + 3*x2 >= 14, name="fiber_minimum")
m.addConstr(4*x1 - 6*x2 >= 0, name="bacon_oranges_ratio")
m.addConstr(8*x1**2 + 3*x2**2 <= 15, name="fiber_squared_maximum")
m.addConstr(8*x1 + 3*x2 <= 15, name="fiber_maximum")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Strips of bacon: {x1.x}")
    print(f"Oranges: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
