
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="strips_of_bacon", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="oranges")

# Objective function
model.setObjective(1.28*x1**2 + 3.91*x2**2 + 8.56*x1 + 5.2*x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(8*x1 + 3*x2 >= 14, name="fiber_min")
model.addConstr(4*x1 - 6*x2 >= 0, name="bacon_orange_ratio")
model.addConstr(8*x1 + 3*x2 <= 15, name="fiber_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Strips of bacon: ", x1.varValue)
    print("Oranges: ", x2.varValue)
else:
    print("The model is infeasible")
