
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
    magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
    vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")


    # Set objective function
    m.setObjective(7*vitamin_b9 + 2*magnesium + 2*vitamin_b7, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11*vitamin_b9 + 3*magnesium + 11*vitamin_b7 <= 73, "muscle_growth_index_ub")
    m.addConstr(7*vitamin_b9 + 10*magnesium + 8*vitamin_b7 <= 91, "immune_support_index_ub")
    m.addConstr(4*vitamin_b9 + 2*magnesium + 5*vitamin_b7 <= 91, "cognitive_performance_index_ub")

    m.addConstr(11*vitamin_b9 + 11*vitamin_b7 >= 23, "c1")
    m.addConstr(11*vitamin_b9 + 3*magnesium >= 8, "c2")
    m.addConstr(11*vitamin_b9 + 3*magnesium + 11*vitamin_b7 >= 8, "c3")
    m.addConstr(10*magnesium + 8*vitamin_b7 >= 10, "c4")
    m.addConstr(7*vitamin_b9 + 10*magnesium >= 12, "c5")
    m.addConstr(7*vitamin_b9 + 10*magnesium + 8*vitamin_b7 >= 17, "c6")
    m.addConstr(4*vitamin_b9 + 2*magnesium >= 27, "c7")
    m.addConstr(2*magnesium + 5*vitamin_b7 >= 21, "c8")
    m.addConstr(4*vitamin_b9 + 2*magnesium + 5*vitamin_b7 >= 21, "c9")
    m.addConstr(5*vitamin_b9 - 4*vitamin_b7 >= 0, "c10")
    m.addConstr(-10*vitamin_b9 + 7*magnesium >= 0, "c11")
    m.addConstr(11*vitamin_b9 + 3*magnesium <= 70, "c12")
    m.addConstr(3*magnesium + 11*vitamin_b7 <= 61, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_b9: %g' % vitamin_b9.x)
        print('magnesium: %g' % magnesium.x)
        print('vitamin_b7: %g' % vitamin_b7.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
