
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
x0 = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B2")
x1 = model.addVar(vtype=GRB.INTEGER, name="milligrams_of_iron")

# Set objective function
model.setObjective(2 * x0 + 2 * x1, GRB.MAXIMIZE)

# Add constraints
model.addConstr(24 * x0 + 19 * x1 >= 63, "kidney_support_lower")
model.addConstr(20 * x0 + 10 * x1 >= 107, "cardio_support_lower")
model.addConstr(-8 * x0 + 6 * x1 >= 0, "constraint_3")
model.addConstr(24 * x0 + 19 * x1 <= 238, "kidney_support_upper")
model.addConstr(20 * x0 + 10 * x1 <= 254, "cardio_support_upper")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("milligrams of vitamin B2:", x0.x)
    print("milligrams of iron:", x1.x)
    print("Objective value:", model.objVal)
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

