
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B2")
x2 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_iron")

# Set the objective function
m.setObjective(2*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(24*x1 + 19*x2 >= 63, name="kidney_support_index_min")
m.addConstr(20*x1 + 10*x2 >= 107, name="cardiovascular_support_index_min")
m.addConstr(-8*x1 + 6*x2 >= 0, name="linear_inequality_constraint")
m.addConstr(24*x1 + 19*x2 <= 238, name="kidney_support_index_max")
m.addConstr(20*x1 + 10*x2 <= 254, name="cardiovascular_support_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B2: {x1.x}")
    print(f"Milligrams of Iron: {x2.x}")
else:
    print("No optimal solution found")
