
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=0, ub=None)  # Vitamin B2, continuous
    x2 = model.addVar(name="x2", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # Iron, integer
    
    # Objective function
    model.setObjective(2*x1 + 2*x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(24*x1 + 19*x2 >= 63)
    model.addConstr(20*x1 + 10*x2 >= 107)
    model.addConstr(-8*x1 + 6*x2 >= 0)
    model.addConstr(24*x1 + 19*x2 <= 238)
    model.addConstr(20*x1 + 10*x2 <= 254)
    
    # Optimize
    model.optimize()
    
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {x1.varValue}")
        print(f"Milligrams of iron: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
