
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(lb=0, name="x0")  # milligrams of potassium
x1 = m.addVar(lb=0, name="x1")  # milligrams of zinc
x2 = m.addVar(lb=0, name="x2")  # milligrams of vitamin B3
x3 = m.addVar(lb=0, name="x3")  # milligrams of magnesium
x4 = m.addVar(lb=0, name="x4")  # grams of carbohydrates
x5 = m.addVar(lb=0, name="x5")  # grams of protein


# Set objective function
m.setObjective(3.99*x0**2 + 7.07*x1**2 + 4.89*x2*x5 + 5.06*x3**2 + 7.64*x3*x4 + 3.65*x4*x5 + 9.06*x5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(19*x4 + 22*x5 >= 59)
m.addConstr(15*x0 + 22*x5 >= 98)
m.addConstr(15*x0 + 29*x1 + 29*x2 + 10*x3 + 19*x4 + 22*x5 >= 98)
m.addConstr(-x1 + 9*x4 >= 0)
m.addConstr(6*x0 - x5 >= 0)
m.addConstr(3*x0 - 10*x3 >= 0)
m.addConstr(-9*x0 + 4*x1 + 10*x3 >= 0)
m.addConstr(29*x1 + 10*x3 <= 161)
m.addConstr(29*x1 + 19*x4 <= 654)
m.addConstr(15*x0**2 + 22*x5**2 <= 220)
m.addConstr(29*x2 + 19*x4 <= 158)
m.addConstr(15*x0 + 29*x1 <= 141)
m.addConstr(29*x2 + 10*x3 + 22*x5 <= 244)
m.addConstr(15*x0 + 29*x1 + 22*x5 <= 467)
m.addConstr(15*x0**2 + 29*x2**2 + 22*x5**2 <= 298)
m.addConstr(29*x1 + 29*x2 + 22*x5 <= 579)
m.addConstr(15*x0**2 + 29*x2**2 + 10*x3**2 <= 488)
m.addConstr(29*x1 + 19*x4 + 22*x5 <= 482)
m.addConstr(29*x1**2 + 10*x3**2 + 19*x4**2 <= 345)
m.addConstr(29*x2**2 + 10*x3**2 + 19*x4**2 <= 455)
m.addConstr(15*x0 + 29*x2 + 19*x4 <= 183)
m.addConstr(29*x1 + 29*x2 + 10*x3 <= 352)
m.addConstr(15*x0 + 10*x3 + 19*x4 <= 476)
m.addConstr(29*x1 + 29*x2 + 19*x4 <= 347)
m.addConstr(15*x0 + 29*x1 + 29*x2 + 10*x3 + 19*x4 + 22*x5 <= 731)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

