
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of potassium")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of zinc")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B3")
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of magnesium")
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of carbohydrates")
    x6 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of protein")

    # Define the objective function
    model.setObjective(3.99*x1**2 + 7.07*x2**2 + 4.89*x3*x6 + 5.06*x4**2 + 7.64*x4*x5 + 3.65*x5*x6 + 9.06*x6, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(15*x1 + 29*x2 + 29*x3 + 10*x4 + 19*x5 + 22*x6 >= 98)
    model.addConstr(15*x1 + 22*x6 >= 98)
    model.addConstr(-x2 + 9*x5 >= 0)
    model.addConstr(6*x1 - x6 >= 0)
    model.addConstr(3*x1 - 10*x4 >= 0)
    model.addConstr(-9*x1 + 4*x2 + 10*x4 >= 0)
    model.addConstr(29*x2 + 10*x4 <= 161)
    model.addConstr(29*x2 + 19*x5 <= 654)
    model.addConstr(15*x1**2 + 22*x6 <= 220)
    model.addConstr(29*x3 + 19*x5 <= 158)
    model.addConstr(15*x1 + 29*x2 <= 141)
    model.addConstr(29*x3 + 10*x4 + 22*x6 <= 244)
    model.addConstr(15*x1 + 29*x2 + 22*x6 <= 467)
    model.addConstr(15*x1**2 + 29*x3**2 + 22*x6**2 <= 298)
    model.addConstr(29*x2 + 29*x3 + 22*x6 <= 579)
    model.addConstr(15*x1**2 + 29*x3**2 + 10*x4**2 <= 488)
    model.addConstr(29*x2 + 19*x5 + 22*x6 <= 482)
    model.addConstr(29*x2**2 + 10*x4**2 + 19*x5**2 <= 345)
    model.addConstr(29*x3**2 + 10*x4**2 + 19*x5**2 <= 455)
    model.addConstr(15*x1 + 29*x3 + 19*x5 <= 183)
    model.addConstr(29*x2 + 29*x3 + 10*x4 <= 352)
    model.addConstr(15*x1 + 10*x4 + 19*x5 <= 476)
    model.addConstr(29*x2 + 29*x3 + 19*x5 <= 347)
    model.addConstr(19*x5 >= 59 - 22*x6)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
