
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
sashimi = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="sashimi")
chicken_drumsticks = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken_drumsticks")
hamburgers = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hamburgers")


# Set objective function
m.setObjective(1 * chicken_breasts + 6 * sashimi + 3 * chicken_drumsticks + 1 * hamburgers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.17 * chicken_breasts + 1.79 * chicken_drumsticks + 3.04 * hamburgers >= 23)
m.addConstr(1.68 * sashimi + 1.79 * chicken_drumsticks + 3.04 * hamburgers >= 23)
m.addConstr(1.17 * chicken_breasts + 1.68 * sashimi + 1.79 * chicken_drumsticks >= 23)

m.addConstr(1.17 * chicken_breasts + 1.79 * chicken_drumsticks + 3.04 * hamburgers >= 16)
m.addConstr(1.68 * sashimi + 1.79 * chicken_drumsticks + 3.04 * hamburgers >= 16)
m.addConstr(1.17 * chicken_breasts + 1.68 * sashimi + 1.79 * chicken_drumsticks >= 16)

m.addConstr(1.17 * chicken_breasts + 1.79 * chicken_drumsticks + 3.04 * hamburgers >= 26)
m.addConstr(1.68 * sashimi + 1.79 * chicken_drumsticks + 3.04 * hamburgers >= 26)
m.addConstr(1.17 * chicken_breasts + 1.68 * sashimi + 1.79 * chicken_drumsticks >= 26)

m.addConstr(1.17 * chicken_breasts + 1.68 * sashimi <= 34)
m.addConstr(1.79 * chicken_drumsticks + 3.04 * hamburgers <= 101)
m.addConstr(1.17 * chicken_breasts + 3.04 * hamburgers <= 122)
m.addConstr(1.68 * sashimi + 3.04 * hamburgers <= 106)
m.addConstr(1.68 * sashimi + 1.79 * chicken_drumsticks + 3.04 * hamburgers <= 41)
m.addConstr(1.17 * chicken_breasts + 1.79 * chicken_drumsticks + 3.04 * hamburgers <= 67)
m.addConstr(1.17 * chicken_breasts + 1.68 * sashimi + 3.04 * hamburgers <= 111)
m.addConstr(1.17 * chicken_breasts + 1.68 * sashimi + 1.79 * chicken_drumsticks + 3.04 * hamburgers <= 111)
m.addConstr(1.17 * chicken_breasts + 1.68 * sashimi + 1.79 * chicken_drumsticks + 3.04 * hamburgers <= 125)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

