
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='chicken breasts')
x2 = m.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name='sashimi')
x3 = m.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name='chicken drumsticks')
x4 = m.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name='hamburgers')

# Define the objective function
m.setObjective(1 * x1 + 6 * x2 + 3 * x3 + 1 * x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.17 * x1 + 1.79 * x3 + 3.04 * x4 >= 23)
m.addConstr(1.68 * x2 + 1.79 * x3 + 3.04 * x4 >= 23)
m.addConstr(1.17 * x1 + 1.68 * x2 + 1.79 * x3 >= 23)
m.addConstr(1.17 * x1 + 1.79 * x3 + 3.04 * x4 >= 16)
m.addConstr(1.68 * x2 + 1.79 * x3 + 3.04 * x4 >= 16)
m.addConstr(1.17 * x1 + 1.68 * x2 + 1.79 * x3 >= 16)
m.addConstr(1.17 * x1 + 1.79 * x3 + 3.04 * x4 >= 26)
m.addConstr(1.68 * x2 + 1.79 * x3 + 3.04 * x4 >= 26)
m.addConstr(1.17 * x1 + 1.68 * x2 + 1.79 * x3 >= 26)
m.addConstr(1.17 * x1 + 1.68 * x2 <= 34)
m.addConstr(1.79 * x3 + 3.04 * x4 <= 101)
m.addConstr(1.17 * x1 + 3.04 * x4 <= 122)
m.addConstr(1.68 * x2 + 3.04 * x4 <= 106)
m.addConstr(1.68 * x2 + 1.79 * x3 + 3.04 * x4 <= 41)
m.addConstr(1.17 * x1 + 1.79 * x3 + 3.04 * x4 <= 67)
m.addConstr(1.17 * x1 + 1.68 * x2 + 3.04 * x4 <= 111)
m.addConstr(1.17 * x1 + 1.68 * x2 + 1.79 * x3 + 3.04 * x4 <= 111)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Chicken breasts: ', x1.varValue)
    print('Sashimi: ', x2.varValue)
    print('Chicken drumsticks: ', x3.varValue)
    print('Hamburgers: ', x4.varValue)
else:
    print('No solution found')
