
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['ravioli', 'apple pies', 'bowls of instant ramen', 'slices of pizza', 'kiwis', 'fruit salads']
x = m.addVars(foods, lb=0.0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS)

# Set objective function
m.setObjective(3*x['ravioli'] + 3*x['apple pies'] + 2*x['bowls of instant ramen'] + x['slices of pizza'] + 4*x['kiwis'] + 5*x['fruit salads'], gp.GRB.MAXIMIZE)

# Add healthiness rating constraints
healthiness_ratings = {'ravioli': 0.62, 'apple pies': 0.01, 'bowls of instant ramen': 0.16, 'slices of pizza': 0.79, 'kiwis': 0.95, 'fruit salads': 0.66}

constraints = [
    (x['apple pies'] * healthiness_ratings['apple pies'] + x['bowls of instant ramen'] * healthiness_ratings['bowls of instant ramen'], ">=", 55),
    # ... (rest of the constraints as in the JSON, using healthiness_ratings dictionary)
]

for vars_, operator, rhs in constraints:
    if operator == ">=":
        m.addConstr(vars_ >= rhs)
    elif operator == "<=":
        m.addConstr(vars_ <= rhs)
    elif operator == "=":
        m.addConstr(vars_ == rhs)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    for food in foods:
        print(f'{food}: {x[food].x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

