
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
patches_per_day = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")

# Set objective function
m.setObjective(9.0 * security_engineers + 2.1 * patches_per_day, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.63 * security_engineers + 3.53 * patches_per_day >= 16, "cost_lower_bound")
m.addConstr(2.84 * security_engineers + 1.26 * patches_per_day >= 36, "bandwidth_lower_bound")
m.addConstr(0.01 * security_engineers + 3.75 * patches_per_day >= 30, "integrity_lower_bound")
m.addConstr(-2 * security_engineers + 1 * patches_per_day >= 0, "custom_constraint")
m.addConstr(0.63 * security_engineers + 3.53 * patches_per_day <= 43, "cost_upper_bound")
m.addConstr(2.84 * security_engineers + 1.26 * patches_per_day <= 118, "bandwidth_upper_bound")
m.addConstr(0.01 * security_engineers + 3.75 * patches_per_day <= 105, "integrity_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('security_engineers:', security_engineers.x)
    print('patches_per_day:', patches_per_day.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

