
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="security_engineers", vtype=gp.GRB.INTEGER)  # security engineers
x2 = m.addVar(name="patches_per_day", vtype=gp.GRB.INTEGER)  # patches per day

# Define the objective function
m.setObjective(9.0 * x1 + 2.1 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.63 * x1 + 3.53 * x2 >= 16)  # dollar cost constraint
m.addConstr(0.63 * x1 + 3.53 * x2 <= 47)  # dollar cost upper bound constraint
m.addConstr(2.84 * x1 + 1.26 * x2 >= 36)  # bandwidth constraint
m.addConstr(2.84 * x1 + 1.26 * x2 <= 184)  # bandwidth upper bound constraint
m.addConstr(0.01 * x1 + 3.75 * x2 >= 30)  # network integrity impact constraint
m.addConstr(0.01 * x1 + 3.75 * x2 <= 105)  # network integrity impact upper bound constraint
m.addConstr(-2 * x1 + x2 >= 0)  # additional constraint

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Security Engineers: {x1.varValue}")
    print(f"Patches per Day: {x2.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
