
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
mary_hours = model.addVar(name="mary_hours", lb=0.0)
dale_hours = model.addVar(name="dale_hours", lb=0.0)
peggy_hours = model.addVar(name="peggy_hours", lb=0.0)


# Set objective function
model.setObjective(8 * mary_hours + 8 * dale_hours + 9 * peggy_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * mary_hours + 3 * dale_hours <= 114, "work_quality_mary_dale")
model.addConstr(3 * dale_hours + 4 * peggy_hours <= 57, "work_quality_dale_peggy")
model.addConstr(6 * mary_hours + 3 * dale_hours + 4 * peggy_hours <= 57, "work_quality_total")
model.addConstr(13 * dale_hours + 4 * peggy_hours >= 37, "computer_competence_dale_peggy")
model.addConstr(2 * mary_hours + 4 * peggy_hours <= 85, "computer_competence_mary_peggy")
model.addConstr(13 * dale_hours + 4 * peggy_hours <= 121, "computer_competence_dale_peggy_max")
model.addConstr(2 * mary_hours + 13 * dale_hours + 4 * peggy_hours <= 88, "computer_competence_total")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Dale's hours: {dale_hours.x}")
    print(f"Peggy's hours: {peggy_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

