
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="hours_worked_by_Mary", lb=0, ub=None)
x1 = m.addVar(name="hours_worked_by_Dale", lb=0, ub=None)
x2 = m.addVar(name="hours_worked_by_Peggy", lb=0, ub=None)

# Objective function
m.setObjective(8*x0 + 8*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(6*x0 <= 118)
m.addConstr(2*x0 <= 123)
m.addConstr(3*x1 <= 118)
m.addConstr(13*x1 <= 123)
m.addConstr(4*x2 <= 118)
m.addConstr(4*x2 <= 123)
m.addConstr(13*x1 + 4*x2 >= 37)
m.addConstr(6*x0 + 3*x1 <= 114)
m.addConstr(3*x1 + 4*x2 <= 57)
m.addConstr(6*x0 + 3*x1 + 4*x2 <= 57)
m.addConstr(2*x0 + 4*x2 <= 85)
m.addConstr(13*x1 + 4*x2 <= 121)
m.addConstr(2*x0 + 13*x1 + 4*x2 <= 88)

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Mary: ", x0.varValue)
    print("Hours worked by Dale: ", x1.varValue)
    print("Hours worked by Peggy: ", x2.varValue)
else:
    print("The problem is infeasible")
