
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # slices of pizza
x1 = m.addVar(name="x1", lb=0)  # cherry pies
x2 = m.addVar(name="x2", lb=0, integrality=gurobi.GRB.INTEGER)  # peanutbutter sandwiches
x3 = m.addVar(name="x3", lb=0, integrality=gurobi.GRB.INTEGER)  # protein bars

# Objective function
m.setObjective(8 * x0 * x1 + 8 * x1 ** 2 + 9 * x2 ** 2 + x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(8 * x0 <= 255)
m.addConstr(6 * x0 + 5 * x1 + 14 * x2 + 24 * x3 <= 271)
m.addConstr(3 * x0 + 8 * x1 + x2 + 15 * x3 <= 146)
m.addConstr(10 * x2 ** 2 + 18 * x3 ** 2 >= 42)
m.addConstr(8 * x0 + 18 * x3 >= 37)
m.addConstr(8 * x0 + 15 * x1 >= 21)
m.addConstr(8 * x0 + 15 * x1 + 10 * x2 + 18 * x3 >= 21)
m.addConstr(6 * x0 + 5 * x1 >= 30)
m.addConstr(36 * x0 ** 2 + 576 * x3 ** 2 >= 50)
m.addConstr(14 * x2 + 24 * x3 >= 41)
m.addConstr(6 * x0 + 14 * x2 >= 49)
m.addConstr(6 * x0 + 5 * x1 + 14 * x2 + 24 * x3 >= 49)
m.addConstr(9 * x0 ** 2 + x2 ** 2 >= 19)
m.addConstr(3 * x0 + 8 * x1 >= 15)
m.addConstr(64 * x1 ** 2 + 225 * x3 ** 2 >= 22)
m.addConstr(3 * x0 + 8 * x1 + x2 + 15 * x3 >= 22)
m.addConstr(4 * x0 ** 2 - 7 * x2 ** 2 >= 0)
m.addConstr(15 * x1 + 18 * x3 <= 223)
m.addConstr(8 * x0 + 18 * x3 <= 182)
m.addConstr(64 * x0 ** 2 + 100 * x2 ** 2 <= 85)
m.addConstr(100 * x2 ** 2 + 324 * x3 ** 2 <= 189)
m.addConstr(225 * x1 ** 2 + 100 * x2 ** 2 <= 159)
m.addConstr(8 * x0 + 15 * x1 <= 140)
m.addConstr(8 * x0 + 10 * x2 + 18 * x3 <= 241)
m.addConstr(15 * x1 + 10 * x2 + 18 * x3 <= 130)
m.addConstr(8 * x0 + 15 * x1 + 18 * x3 <= 231)
m.addConstr(8 * x0 + 15 * x1 + 10 * x2 <= 216)
m.addConstr(6 * x0 + 14 * x2 <= 139)
m.addConstr(6 * x0 + 5 * x1 <= 110)
m.addConstr(25 * x1 ** 2 + 196 * x2 ** 2 <= 200)
m.addConstr(6 * x0 + 24 * x3 <= 239)
m.addConstr(6 * x0 + 5 * x1 + 24 * x3 <= 156)
m.addConstr(8 * x1 + 15 * x3 <= 86)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
