
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="bowls of instant ramen")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="corn cobs")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bowls of cereal")


# Set objective function
m.setObjective(2.11 * x0 + 9.07 * x1 + 3.76 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * x0 + 28 * x2 >= 73, "calcium_constraint1")
m.addConstr(30 * x1 + 28 * x2 >= 30, "calcium_constraint2")
m.addConstr(16 * x0 + 30 * x1 + 28 * x2 >= 30, "calcium_constraint3")
m.addConstr(-9 * x0 + 6 * x2 >= 0, "constraint4")
m.addConstr(-2 * x0 + 8 * x1 >= 0, "constraint5")
m.addConstr(16 * x0 + 30 * x1 + 28 * x2 <= 113, "calcium_constraint6")
m.addConstr(16 * x0 + 30 * x1 + 28 * x2 <= 239, "calcium_constraint7")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Solution:')
    print(f"  bowls of instant ramen: {x0.x}")
    print(f"  corn cobs: {x1.x}")
    print(f"  bowls of cereal: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

