
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="bowls_of_instant_ramenn")
x2 = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_cereal")

# Set objective function
m.setObjective(2.11*x1 + 9.07*x2 + 3.76*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x1 + 28*x3 >= 73, name="calcium_from_instant_ramenn_and_cereal")
m.addConstr(30*x2 + 28*x3 >= 30, name="calcium_from_corn_cobs_and_cereal")
m.addConstr(16*x1 + 30*x2 + 28*x3 >= 30, name="total_calcium_minimum")
m.addConstr(-9*x1 + 6*x3 >= 0, name="instant_ramenn_and_cereal_quantity_constraint")
m.addConstr(-2*x1 + 8*x2 >= 0, name="instant_ramenn_and_corn_cobs_quantity_constraint")
m.addConstr(16*x1 + 30*x2 + 28*x3 <= 113, name="total_calcium_maximum")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"bowls_of_instant_ramenn: {x1.x}")
    print(f"corn_cobs: {x2.x}")
    print(f"bowls_of_cereal: {x3.x}")
else:
    print("No optimal solution found")
