
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="bowls_of_instant_ramen", vtype=gurobi.GRB.INTEGER)  # bowls of instant ramen
    x2 = model.addVar(name="corn_cobs", vtype=gurobi.GRB.INTEGER)  # corn cobs
    x3 = model.addVar(name="bowls_of_cereal")  # bowls of cereal

    # Objective function
    model.setObjective(2.11 * x1 + 9.07 * x2 + 3.76 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(16 * x1 + 28 * x3 >= 73, name="calcium_from_ramen_and_cereal")
    model.addConstr(30 * x2 + 28 * x3 >= 30, name="calcium_from_corn_cobs_and_cereal")
    model.addConstr(16 * x1 + 30 * x2 + 28 * x3 >= 30, name="calcium_from_all_sources_min")
    model.addConstr(-9 * x1 + 6 * x3 >= 0, name="linear_constraint_1")
    model.addConstr(-2 * x1 + 8 * x2 >= 0, name="linear_constraint_2")
    model.addConstr(16 * x1 + 30 * x2 + 28 * x3 <= 113, name="calcium_from_all_sources_max")
    model.addConstr(16 * x1 + 30 * x2 + 28 * x3 <= 239, name="calcium_upper_bound")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("bowls of instant ramen: ", x1.varValue)
        print("corn cobs: ", x2.varValue)
        print("bowls of cereal: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
