
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")
blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")


# Set objective function
m.setObjective(7*bananas + 8*peanutbutter_sandwiches + 4*apple_pies + 2*eggs + 1*blueberry_pies + 2*green_beans, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12*bananas + 1*peanutbutter_sandwiches + 9*apple_pies + 9*eggs + 3*blueberry_pies + 1*green_beans <= 186, "r0")
m.addConstr(13*bananas + 10*peanutbutter_sandwiches + 14*apple_pies + 11*eggs + 7*blueberry_pies + 14*green_beans <= 248, "r1")
m.addConstr(16*bananas + 14*peanutbutter_sandwiches + 13*apple_pies + 14*eggs + 10*blueberry_pies + 13*green_beans <= 376, "r2")
m.addConstr(12*bananas + 3*blueberry_pies >= 28, "c3")
m.addConstr(1*peanutbutter_sandwiches + 9*eggs + 3*blueberry_pies >= 29, "c4")
# ... (add all other constraints similarly)
m.addConstr(16 * bananas + 10 * blueberry_pies >= 23, "c202")
m.addConstr(13 * apple_pies + 13 * green_beans >= 41, "c203")
m.addConstr(10 * blueberry_pies + 13 * green_beans >= 28, "c204")
m.addConstr(14 * peanutbutter_sandwiches + 13 * apple_pies >= 54, "c205")
m.addConstr(16 * bananas + 14 * eggs >= 27, "c206")
m.addConstr(16 * bananas + 14 * peanutbutter_sandwiches >= 40, "c207")
m.addConstr(13 * apple_pies + 10 * blueberry_pies + 13 * green_beans >= 35, "c208")
m.addConstr(16 * bananas + 14 * peanutbutter_sandwiches + 13 * apple_pies + 14 * eggs + 10 * blueberry_pies + 13 * green_beans >= 35, "c209")
m.addConstr(-6 * peanutbutter_sandwiches + 4 * blueberry_pies >= 0, "c210")
m.addConstr(-5 * peanutbutter_sandwiches + 3 * eggs >= 0, "c211")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

