
import gurobi as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
x = model.addVars(6, name="x", lb=0)  # Assuming lb=0 for all variables

# Objective function coefficients
obj_coeffs = [7, 8, 4, 2, 1, 2]

# Set the objective function
model.setObjective(gp.quicksum(obj_coeffs[i] * x[i] for i in range(6)), gp.GRB.MINIMIZE)

# Resource constraints
resources = {
    'r0': {'description': 'grams of fat', 'upper_bound': 186, 'x': [12, 1, 9, 9, 3, 1]},
    'r1': {'description': 'sourness index', 'upper_bound': 248, 'x': [13, 10, 14, 11, 7, 14]},
    'r2': {'description': 'grams of fiber', 'upper_bound': 376, 'x': [16, 14, 13, 14, 10, 13]}
}

# Add resource constraints
for r in resources.values():
    model.addConstr(gp.quicksum(r['x'][i] * x[i] for i in range(6)) <= r['upper_bound'], r['description'])

# Fat constraints
fat_constraints = [
    gp.quicksum([12, 3]) * x[0] + x[4] >= 28,
    gp.quicksum([1, 9, 9]) * x[1] + x[3] + x[4] >= 29,
    gp.quicksum([9, 9, 1]) * x[2] + x[3] + x[5] >= 29,
    gp.quicksum([12, 1, 9]) * x[0] + x[1] + x[3] >= 29,
    gp.quicksum([12, 1, 3]) * x[0] + x[1] + x[4] >= 29,
    gp.quicksum([9, 9, 1]) * x[0] + x[2] + x[5] >= 29,
    gp.quicksum([12, 3, 1]) * x[0] + x[4] + x[5] >= 29,
    gp.quicksum([1, 9, 3]) * x[1] + x[2] + x[4] + x[5] >= 29,
    gp.quicksum([1, 9, 9]) * x[1] + x[2] + x[3] >= 29,
    gp.quicksum([12, 1, 3]) * x[0] + x[2] + x[4] >= 29,
    gp.quicksum([12, 9, 1]) * x[0] + x[3] + x[5] >= 29,
    gp.quicksum([12, 1, 1]) * x[0] + x[1] + x[2] >= 29,
    gp.quicksum([1, 3, 1]) * x[1] + x[4] + x[5] >= 29,
    gp.quicksum([12, 11, 14]) * x[0] + x[3] + x[4] >= 31,
    gp.quicksum([1, 14, 7]) * x[1] + x[3] + x[4] >= 31,
    gp.quicksum([9, 11, 13]) * x[2] + x[3] + x[5] >= 31,
    gp.quicksum([12, 10, 14]) * x[0] + x[1] + x[3] >= 31,
    gp.quicksum([12, 10, 7]) * x[0] + x[1] + x[4] >= 31,
    gp.quicksum([9, 11, 13]) * x[0] + x[2] + x[5] >= 31,
    gp.quicksum([9, 14, 10]) * x[2] + x[4] + x[5] >= 31,
    gp.quicksum([1, 9, 14]) * x[1] + x[2] + x[3] >= 31,
    gp.quicksum([7, 14, 10]) * x[0] + x[2] + x[4] >= 31,
    gp.quicksum([13, 11, 14]) * x[0] + x[3] + x[5] >= 31,
]

# Add fat constraints
for constr in fat_constraints:
    model.addConstr(constr)

# Sourness index constraints
sourness_constraints = [
    gp.quicksum([13, 10]) * x[0] + x[1] >= 15,
    gp.quicksum([13, 11]) * x[0] + x[3] >= 20,
    gp.quicksum([13, 14]) * x[0] + x[1] >= 15,
    gp.quicksum([13, 7]) * x[0] + x[4] >= 22,
    gp.quicksum([14, 7]) * x[2] + x[4] >= 19,
    gp.quicksum([10, 14]) * x[1] + x[5] >= 25,
    gp.quicksum([13, 14]) * x[0] + x[5] >= 38,
    gp.quicksum([13, 14]) * x[0] + x[2] >= 23,
    gp.quicksum([14, 7]) * x[2] + x[5] >= 38,
    gp.quicksum([11, 7]) * x[3] + x[4] >= 32,
    gp.quicksum([10, 14]) * x[1] + x[2] >= 30,
    gp.quicksum([11, 14, 7]) * x[3] + x[4] + x[5] >= 34,
    gp.quicksum([14, 7, 13]) * x[2] + x[4] + x[5] >= 34,
    gp.quicksum([13, 10, 14]) * x[0] + x[1] + x[2] >= 34,
    gp.quicksum([13, 7, 14]) * x[0] + x[4] + x[5] >= 34,
    gp.quicksum([13, 14, 7]) * x[0] + x[2] + x[4] >= 34,
    gp.quicksum([13, 10, 14]) * x[0] + x[1] + x[4] >= 34,
    gp.quicksum([13, 11, 14]) * x[0] + x[3] + x[5] >= 34,
]

# Add sourness index constraints
for constr in sourness_constraints:
    model.addConstr(constr)

# Fiber constraints
fiber_constraints = [
    gp.quicksum([16, 10]) * x[0] + x[4] >= 23,
    gp.quicksum([13, 10, 13]) * x[2] + x[4] + x[5] >= 41,
    gp.quicksum([10, 13]) * x[4] + x[5] >= 28,
    gp.quicksum([14, 13]) * x[1] + x[2] >= 54,
    gp.quicksum([16, 14]) * x[0] + x[3] >= 27,
    gp.quicksum([16, 14]) * x[0] + x[1] >= 40,
    gp.quicksum([13, 10, 13]) * x[2] + x[4] + x[5] >= 35,
]

# Add fiber constraints
for constr in fiber_constraints:
    model.addConstr(constr)

# Other constraints
model.addConstr(-6 * x[1] + 4 * x[4] >= 0)
model.addConstr(-5 * x[1] + 3 * x[3] >= 0)

# Bounds on fat
fat_bounds = [
    gp.quicksum([12, 9]) * x[0] + x[3] <= 158,
    gp.quicksum([3, 1]) * x[4] + x[5] <= 157,
    gp.quicksum([12, 3]) * x[0] + x[4] <= 34,
    gp.quicksum([9, 1]) * x[3] + x[5] <= 137,
    gp.quicksum([12, 1]) * x[0] + x[1] <= 66,
    gp.quicksum([1, 9]) * x[1] + x[2] <= 144,
    gp.quicksum([9, 1]) * x[2] + x[5] <= 109,
    gp.quicksum([9, 3]) * x[3] + x[4] <= 147,
    gp.quicksum([9, 3]) * x[2] + x[4] <= 143,
    gp.quicksum([1, 3]) * x[1] + x[4] <= 33,
    gp.quicksum([12, 1]) * x[0] + x[5] <= 142,
]

# Add bounds on fat
for constr in fat_bounds:
    model.addConstr(constr)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    for i in range(6):
        print(f"x[{i}] = {model.x[i].varValue}")
else:
    print("No optimal solution found")
