
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x = m.addVars(4, name=["military_intelligence", "water_purification", "armored", "light_infantry"], type=gp.GRB.INTEGER)


    # Set objective function
    m.setObjective(7*x[0] + 3*x[1] + 9*x[2] + 3*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*x[0] + 6*x[1] + 6*x[2] + 4*x[3] >= 12, "defensive_capability_1")
    m.addConstr(4*x[0] + 4*x[1] >= 5, "logistics_footprint_1")
    m.addConstr(4*x[0] + 4*x[1] + 7*x[3] >= 9, "logistics_footprint_2")
    m.addConstr(6*x[2] + 4*x[3] <= 35, "defensive_capability_2")
    m.addConstr(2*x[0] + 6*x[1] <= 43, "defensive_capability_3")
    m.addConstr(2*x[0] + 4*x[3] <= 31, "defensive_capability_4")
    m.addConstr(2*x[0] + 6*x[2] <= 47, "defensive_capability_5")
    m.addConstr(6*x[1] + 6*x[2] <= 37, "defensive_capability_6")
    m.addConstr(6*x[1] + 6*x[2] + 4*x[3] <= 39, "defensive_capability_7")
    m.addConstr(2*x[0] + 6*x[1] + 6*x[2] + 4*x[3] <= 39, "defensive_capability_8")
    m.addConstr(x[2] + 7*x[3] <= 30, "logistics_footprint_3")
    m.addConstr(4*x[0] + 4*x[1] <= 36, "logistics_footprint_4")
    m.addConstr(4*x[1] + 7*x[3] <= 30, "logistics_footprint_5")
    m.addConstr(4*x[1] + x[2] <= 26, "logistics_footprint_6")
    m.addConstr(4*x[0] + x[2] <= 18, "logistics_footprint_7")
    m.addConstr(4*x[0] + 4*x[1] + x[2] + 7*x[3] <= 18, "logistics_footprint_8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
