
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="military_intelligence_companies", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="water_purification_units", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="armored_companies", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="light_infantry_companies", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7*x0 + 3*x1 + 9*x2 + 3*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 6*x1 + 6*x2 + 4*x3 >= 12)
m.addConstr(4*x0 + 4*x1 >= 5)
m.addConstr(4*x0 + 4*x1 + 7*x3 >= 9)
m.addConstr(6*x2 + 4*x3 <= 35)
m.addConstr(2*x0 + 6*x1 <= 43)
m.addConstr(2*x0 + 4*x3 <= 31)
m.addConstr(2*x0 + 6*x2 <= 47)
m.addConstr(6*x1 + 6*x2 <= 37)
m.addConstr(6*x1 + 6*x2 + 4*x3 <= 39)
m.addConstr(2*x0 + 6*x1 + 6*x2 + 4*x3 <= 39)
m.addConstr(x2 + 7*x3 <= 30)
m.addConstr(4*x0 + 4*x1 <= 36)
m.addConstr(4*x1 + 7*x3 <= 30)
m.addConstr(4*x1 + x2 <= 26)
m.addConstr(4*x0 + x2 <= 18)
m.addConstr(4*x0 + 4*x1 + x2 + 7*x3 <= 18)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("military intelligence companies: ", x0.varValue)
    print("water purification units: ", x1.varValue)
    print("armored companies: ", x2.varValue)
    print("light infantry companies: ", x3.varValue)
else:
    print("The model is infeasible")
