
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(3, name=["green_beans", "protein_bars", "cornichons"], vtype=gp.GRB.INTEGER)

# Set objective function
m.setObjective(4.82 * x[0] + 2.3 * x[1] + 7.85 * x[2], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(23 * x[0] + 21 * x[1] + 21 * x[2] >= 62)
m.addConstr(21 * x[0] + 1 * x[1] >= 49)
m.addConstr(1 * x[1] + 31 * x[2] >= 41)
m.addConstr(21 * x[0] + 1 * x[1] + 31 * x[2] >= 37)
m.addConstr(22 * x[1] + 29 * x[2] >= 98)
m.addConstr(13 * x[0] + 22 * x[1] >= 65)
m.addConstr(13 * x[0] + 22 * x[1] + 29 * x[2] >= 78)
m.addConstr(5 * x[1] + 16 * x[2] >= 59)
m.addConstr(11 * x[0] + 16 * x[2] >= 95)
m.addConstr(11 * x[0] + 5 * x[1] >= 129)
m.addConstr(23 * x[0] + 21 * x[1] <= 128)
m.addConstr(23 * x[0] + 21 * x[2] <= 201)
m.addConstr(21 * x[1] + 21 * x[2] <= 191)
m.addConstr(23 * x[0] + 21 * x[1] + 21 * x[2] <= 191)
m.addConstr(21 * x[0] + 1 * x[1] <= 120)
m.addConstr(1 * x[1] + 31 * x[2] <= 72)
m.addConstr(21 * x[0] + 1 * x[1] + 31 * x[2] <= 102)
m.addConstr(27 * x[0] + 28 * x[1] <= 215)
m.addConstr(28 * x[1] + 16 * x[2] <= 339)
m.addConstr(27 * x[0] + 16 * x[2] <= 258)
m.addConstr(27 * x[0] + 28 * x[1] + 16 * x[2] <= 328)
m.addConstr(22 * x[1] + 29 * x[2] <= 383)
m.addConstr(13 * x[0] + 29 * x[2] <= 182)
m.addConstr(13 * x[0] + 22 * x[1] + 29 * x[2] <= 182)
m.addConstr(11 * x[0] + 5 * x[1] <= 175)
m.addConstr(11 * x[0] + 5 * x[1] + 16 * x[2] <= 175)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

