
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='green_beans', vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name='protein_bars', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='cornichons', vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4.82 * x0 + 2.3 * x1 + 7.85 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(23 * x0 + 21 * x1 + 21 * x2 >= 62)
m.addConstr(21 * x0 + x1 >= 49)
m.addConstr(x1 + 31 * x2 >= 41)
m.addConstr(21 * x0 + x1 + 31 * x2 >= 37)
m.addConstr(22 * x1 + 29 * x2 >= 98)
m.addConstr(13 * x0 + 22 * x1 >= 65)
m.addConstr(13 * x0 + 22 * x1 + 29 * x2 >= 78)
m.addConstr(5 * x1 + 16 * x2 >= 59)
m.addConstr(11 * x0 + 16 * x2 >= 95)
m.addConstr(11 * x0 + 5 * x1 >= 129)
m.addConstr(23 * x0 + 21 * x1 <= 128)
m.addConstr(23 * x0 + 21 * x2 <= 201)
m.addConstr(21 * x1 + 21 * x2 <= 191)
m.addConstr(23 * x0 + 21 * x1 + 21 * x2 <= 191)
m.addConstr(21 * x0 + x1 <= 120)
m.addConstr(x1 + 31 * x2 <= 72)
m.addConstr(21 * x0 + x1 + 31 * x2 <= 102)
m.addConstr(27 * x0 + 28 * x1 <= 215)
m.addConstr(28 * x1 + 16 * x2 <= 339)
m.addConstr(27 * x0 + 16 * x2 <= 258)
m.addConstr(27 * x0 + 28 * x1 + 16 * x2 <= 328)
m.addConstr(22 * x1 + 29 * x2 <= 383)
m.addConstr(13 * x0 + 29 * x2 <= 182)
m.addConstr(13 * x0 + 22 * x1 + 29 * x2 <= 182)
m.addConstr(11 * x0 + 5 * x1 <= 175)
m.addConstr(11 * x0 + 5 * x1 + 16 * x2 <= 175)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Green beans: ', x0.varValue)
    print('Protein bars: ', x1.varValue)
    print('Cornichons: ', x2.varValue)
else:
    print('No optimal solution found')
