
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["peanutbutter sandwiches", "chicken thighs", "sashimi", "apple pies"])


# Set objective function
m.setObjective(6.81 * x[0] + 5.9 * x[1] + 9.09 * x[2] + 4.3 * x[3], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x[0] + 5 * x[1] >= 21)
m.addConstr(5 * x[1] + 4 * x[2] >= 19)
m.addConstr(6 * x[0] + 5 * x[1] + 4 * x[2] >= 24)
m.addConstr(6 * x[0] + 4 * x[2] + 10 * x[3] >= 24)
m.addConstr(5 * x[1] + 4 * x[2] + 10 * x[3] >= 24)
m.addConstr(6 * x[0] + 5 * x[1] + 4 * x[2] >= 12)
m.addConstr(6 * x[0] + 4 * x[2] + 10 * x[3] >= 12)
m.addConstr(5 * x[1] + 4 * x[2] + 10 * x[3] >= 12)
m.addConstr(6 * x[0] + 5 * x[1] + 4 * x[2] >= 13)
m.addConstr(6 * x[0] + 4 * x[2] + 10 * x[3] >= 13)
m.addConstr(5 * x[1] + 4 * x[2] + 10 * x[3] >= 13)
m.addConstr(6 * x[0] + 5 * x[1] + 4 * x[2] + 10 * x[3] >= 13)
m.addConstr(9 * x[0] + x[3] >= 16)
m.addConstr(2 * x[2] + x[3] >= 13)
m.addConstr(9 * x[0] + 4 * x[1] >= 8)
m.addConstr(4 * x[1] + 2 * x[2] >= 11)
m.addConstr(4 * x[1] + x[3] >= 9)
m.addConstr(9 * x[0] + 4 * x[1] + 2 * x[2] + x[3] >= 9)
m.addConstr(2 * x[1] - 8 * x[3] >= 0)
m.addConstr(9 * x[2] - 8 * x[3] >= 0)
m.addConstr(5 * x[1] + 4 * x[2] <= 91)
m.addConstr(5 * x[1] + 10 * x[3] <= 57)
m.addConstr(4 * x[1] + x[3] <= 16)
m.addConstr(9 * x[0] + 2 * x[2] <= 34)

# Resource constraints (iron and tastiness)
m.addConstr(6 * x[0] + 5 * x[1] + 4 * x[2] + 10 * x[3] <= 97)
m.addConstr(9 * x[0] + 4 * x[1] + 2 * x[2] + x[3] <= 66)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

