
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="peanutbutter_sandwiches", lb=0)
    x1 = model.addVar(name="chicken_thighs", lb=0)
    x2 = model.addVar(name="sashimi", lb=0)
    x3 = model.addVar(name="apple_pies", lb=0)

    # Objective function
    model.setObjective(6.81 * x0 + 5.9 * x1 + 9.09 * x2 + 4.3 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6 * x0 + 5 * x1 >= 21)
    model.addConstr(5 * x1 + 4 * x2 >= 19)
    model.addConstr(6 * x0 + 5 * x1 + 4 * x2 >= 24)
    model.addConstr(6 * x0 + 4 * x2 + 10 * x3 >= 24)
    model.addConstr(5 * x1 + 4 * x2 + 10 * x3 >= 24)
    model.addConstr(6 * x0 + 5 * x1 + 4 * x2 >= 12)
    model.addConstr(6 * x0 + 4 * x2 + 10 * x3 >= 12)
    model.addConstr(5 * x1 + 4 * x2 + 10 * x3 >= 12)
    model.addConstr(6 * x0 + 5 * x1 + 4 * x2 >= 13)
    model.addConstr(6 * x0 + 4 * x2 + 10 * x3 >= 13)
    model.addConstr(5 * x1 + 4 * x2 + 10 * x3 >= 13)
    model.addConstr(6 * x0 + 5 * x1 + 4 * x2 + 10 * x3 >= 13)
    model.addConstr(9 * x0 + x3 >= 16)
    model.addConstr(2 * x2 + x3 >= 13)
    model.addConstr(9 * x0 + 4 * x1 >= 8)
    model.addConstr(4 * x1 + 2 * x2 >= 11)
    model.addConstr(4 * x1 + x3 >= 9)
    model.addConstr(9 * x0 + 4 * x1 + 2 * x2 + x3 >= 9)
    model.addConstr(2 * x1 - 8 * x3 >= 0)
    model.addConstr(9 * x2 - 8 * x3 >= 0)
    model.addConstr(5 * x1 + 4 * x2 <= 91)
    model.addConstr(5 * x1 + 10 * x3 <= 57)
    model.addConstr(4 * x1 + x3 <= 16)
    model.addConstr(9 * x0 + 2 * x2 <= 34)

    # Resource bounds
    model.addConstr(6 * x0 + 5 * x1 + 4 * x2 + 10 * x3 <= 97)
    model.addConstr(9 * x0 + 4 * x1 + 2 * x2 + x3 <= 66)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("peanutbutter sandwiches: ", x0.varValue)
        print("chicken thighs: ", x1.varValue)
        print("sashimi: ", x2.varValue)
        print("apple pies: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
