
from gurobipy import *

# Create a new model
m = Model("Work Optimization")

# Create variables
ringo = m.addVar(vtype=GRB.INTEGER, name="ringo")
jean = m.addVar(vtype=GRB.CONTINUOUS, name="jean")
mary = m.addVar(vtype=GRB.CONTINUOUS, name="mary")
laura = m.addVar(vtype=GRB.INTEGER, name="laura")
peggy = m.addVar(vtype=GRB.INTEGER, name="peggy")
john = m.addVar(vtype=GRB.CONTINUOUS, name="john")
george = m.addVar(vtype=GRB.CONTINUOUS, name="george")


# Set objective
m.setObjective(ringo**2 + 3*ringo*jean + 2*ringo*laura + 2*ringo*peggy + 5*ringo*john + 4*jean**2 + 7*jean*peggy + 5*jean*george + 7*mary*laura + 8*mary*peggy + 9*laura*peggy + 6*laura*john + 8*peggy**2 + 4*peggy*john + 3*peggy*george + john*george + 4*george**2 + 4*jean + mary + 3*john + 3*george, GRB.MAXIMIZE)

# Add constraints
ratings = {'ringo': 16, 'jean': 12, 'mary': 3, 'laura': 9, 'peggy': 12, 'john': 5, 'george': 6}

m.addConstr(ratings['laura']*laura**2 + ratings['george']*george**2 >= 25)
# ... (add all other constraints using the ratings dictionary as above)

# Add upper bound constraint based on 'r0' resource
m.addConstr(ratings['ringo']*ringo + ratings['jean']*jean + ratings['mary']*mary + ratings['laura']*laura + ratings['peggy']*peggy + ratings['john']*john + ratings['george']*george <= 525, "r0_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

