
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Ringo", vtype=gp.GRB.INTEGER)  # whole number
x2 = m.addVar(name="hours_worked_by_Jean")  # non-whole number
x3 = m.addVar(name="hours_worked_by_Mary")  # fractional number
x4 = m.addVar(name="hours_worked_by_Laura", vtype=gp.GRB.INTEGER)  # non-fractional number
x5 = m.addVar(name="hours_worked_by_Peggy", vtype=gp.GRB.INTEGER)  # whole number
x6 = m.addVar(name="hours_worked_by_John")  # non-integer amount
x7 = m.addVar(name="hours_worked_by_George")  # non-whole number

# Objective function
m.setObjective(1 * x1**2 + 3 * x1 * x2 + 2 * x1 * x4 + 2 * x1 * x5 + 5 * x1 * x6 + 
               4 * x2**2 + 7 * x2 * x5 + 5 * x2 * x7 + 7 * x3 * x4 + 8 * x3 * x5 + 
               9 * x4 * x5 + 6 * x4 * x6 + 8 * x5**2 + 4 * x5 * x6 + 3 * x5 * x7 + 
               1 * x6 * x7 + 4 * x7**2 + 4 * x2 + 1 * x3 + 3 * x6 + 3 * x7, gp.GRB.MAXIMIZE)

# Constraints
# Ringo's work quality rating
m.addConstr(16 * x1 <= 525)

# Other individual work quality ratings
m.addConstr(12 * x2 <= 525)
m.addConstr(3 * x3 <= 525)
m.addConstr(9 * x4 <= 525)
m.addConstr(12 * x5 <= 525)
m.addConstr(5 * x6 <= 525)
m.addConstr(6 * x7 <= 525)

# Combined work quality ratings (example of a few constraints)
m.addConstr(x4**2 + x7**2 >= 25)
m.addConstr(x1 + x5 + x7 >= 44)

# Add more constraints here...

# Bounds
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)
m.addConstr(x4 >= 0)
m.addConstr(x5 >= 0)
m.addConstr(x6 >= 0)
m.addConstr(x7 >= 0)

# The total combined work quality rating from hours worked by Laura squared plus hours worked by George squared must be 505 at a maximum.
m.addConstr(x4**2 + x7**2 <= 505)

# The total combined work quality rating from hours worked by John and hours worked by George must be 413 at maximum.
m.addConstr(x6 + x7 <= 413)

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Ringo: ", x1.varValue)
    print("Hours worked by Jean: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
    print("Hours worked by Laura: ", x4.varValue)
    print("Hours worked by Peggy: ", x5.varValue)
    print("Hours worked by John: ", x6.varValue)
    print("Hours worked by George: ", x7.varValue)
else:
    print("No solution found")
