
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    x = model.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["John", "Jean", "Ringo", "Bill"])


    # Set objective function
    model.setObjective(9.2 * x[0] + 1.4 * x[1] + 1.15 * x[2] + 2.34 * x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(8 * x[0] + 9 * x[1] >= 22)
    model.addConstr(9 * x[1] + 18 * x[2] >= 18)
    model.addConstr(16 * x[1] + 9 * x[3] >= 33)
    model.addConstr(1 * x[0] + 9 * x[3] >= 35)
    model.addConstr(1 * x[0] + 16 * x[1] >= 42)
    model.addConstr(1 * x[0] + 10 * x[2] >= 36)
    model.addConstr(16 * x[1] + 10 * x[2] >= 38)
    model.addConstr(1 * x[0] + 10 * x[2] + 9 * x[3] >= 31)
    model.addConstr(16 * x[1] + 10 * x[2] + 9 * x[3] >= 31)
    model.addConstr(1 * x[0] + 10 * x[2] + 9 * x[3] >= 39)
    model.addConstr(16 * x[1] + 10 * x[2] + 9 * x[3] >= 39)
    model.addConstr(8 * x[0] + 9 * x[1] <= 47)
    model.addConstr(8 * x[0] + 9 * x[1] + 18 * x[2] <= 37)
    model.addConstr(8 * x[0] + 9 * x[1] + 18 * x[2] + 12 * x[3] <= 37)
    model.addConstr(1 * x[0] + 10 * x[2] <= 143)
    model.addConstr(1 * x[0] + 9 * x[3] <= 105)
    model.addConstr(1 * x[0] + 16 * x[1] + 9 * x[3] <= 93)
    model.addConstr(1 * x[0] + 10 * x[2] + 9 * x[3] <= 93)
    model.addConstr(1 * x[0] + 16 * x[1] + 10 * x[2] + 9 * x[3] <= 93)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
