
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by John
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Jean
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Ringo
    x3 = model.addVar(name='x3', lb=0)  # hours worked by Bill

    # Equality constraints
    model.addConstr(8 * x0 == 8, name='john_likelihood')
    model.addConstr(1 * x0 == 1, name='john_quality')
    model.addConstr(9 * x1 == 9, name='jean_likelihood')
    model.addConstr(16 * x1 == 16, name='jean_quality')
    model.addConstr(18 * x2 == 18, name='ringo_likelihood')
    model.addConstr(10 * x2 == 10, name='ringo_quality')
    model.addConstr(12 * x3 == 12, name='bill_likelihood')
    model.addConstr(9 * x3 == 9, name='bill_quality')

    # Inequality constraints
    model.addConstr(8 * x0 + 9 * x1 >= 22, name='john_jean_likelihood')
    model.addConstr(9 * x1 + 18 * x2 >= 18, name='jean_ringo_likelihood')
    model.addConstr(16 * x1 + 9 * x3 >= 33, name='jean_bill_quality')
    model.addConstr(1 * x0 + 9 * x3 >= 35, name='john_bill_quality')
    model.addConstr(1 * x0 + 16 * x1 >= 42, name='john_jean_quality')
    model.addConstr(1 * x0 + 10 * x2 >= 36, name='john_ringo_quality')
    model.addConstr(16 * x1 + 10 * x2 >= 38, name='jean_ringo_quality')
    model.addConstr(1 * x0 + 10 * x2 + 9 * x3 >= 31, name='john_ringo_bill_quality1')
    model.addConstr(16 * x1 + 10 * x2 + 9 * x3 >= 31, name='jean_ringo_bill_quality1')
    model.addConstr(1 * x0 + 10 * x2 + 9 * x3 >= 39, name='john_ringo_bill_quality2')
    model.addConstr(16 * x1 + 10 * x2 + 9 * x3 >= 39, name='jean_ringo_bill_quality2')
    model.addConstr(8 * x0 + 9 * x1 <= 47, name='john_jean_likelihood_ub')
    model.addConstr(8 * x0 + 9 * x1 + 18 * x2 <= 37, name='john_jean_ringo_likelihood_ub')
    model.addConstr(8 * x0 + 9 * x1 + 18 * x2 + 12 * x3 <= 37, name='all_likelihood_ub')
    model.addConstr(1 * x0 + 10 * x2 <= 143, name='john_ringo_quality_ub')
    model.addConstr(1 * x0 + 9 * x3 <= 105, name='john_bill_quality_ub')
    model.addConstr(1 * x0 + 16 * x1 + 9 * x3 <= 93, name='john_jean_bill_quality_ub')
    model.addConstr(1 * x0 + 10 * x2 + 9 * x3 <= 93, name='john_ringo_bill_quality_ub')
    model.addConstr(1 * x0 + 16 * x1 + 10 * x2 + 9 * x3 <= 93, name='all_quality_ub')

    # Objective function
    model.setObjective(9.2 * x0 + 1.4 * x1 + 1.15 * x2 + 2.34 * x3, gurobi.GRB.MAXIMIZE)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('x0: ', x0.varValue)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
