
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Mary
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1") # hours worked by Laura
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Peggy
    x3 = model.addVar(vtype=gp.GRB.INTEGER, name="x3") # hours worked by John


    # Set objective function
    model.setObjective(6.59 * x0 + 2.27 * x1 + 9.41 * x2 + 8.96 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1 * x0 + 5 * x1 >= 21, "c0")
    model.addConstr(1 * x0 + 14 * x2 >= 39, "c1")
    model.addConstr(5 * x1 + 14 * x2 + 1 * x3 >= 45, "c2")
    model.addConstr(1 * x0 + 5 * x1 + 14 * x2 + 1 * x3 >= 45, "c3")
    model.addConstr(6 * x1 + 4 * x3 >= 13, "c4")
    model.addConstr(6 * x2 + 4 * x3 >= 25, "c5")
    model.addConstr(6 * x1 + 6 * x2 >= 11, "c6")
    model.addConstr(15 * x0 + 6 * x1 + 6 * x2 + 4 * x3 >= 11, "c7")
    model.addConstr(9 * x2 - 4 * x3 >= 0, "c8")
    model.addConstr(1 * x0 + 5 * x1 + 1 * x3 <= 216, "c9")
    model.addConstr(5 * x1 + 14 * x2 + 1 * x3 <= 225, "c10")
    model.addConstr(1 * x0 + 5 * x1 + 14 * x2 <= 134, "c11")
    model.addConstr(15 * x0 + 6 * x1 + 6 * x2 <= 84, "c12")
    model.addConstr(6 * x1 + 6 * x2 + 4 * x3 <= 112, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
