
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Laura
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Peggy
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by John

    # Objective function
    model.setObjective(6.59 * x0 + 2.27 * x1 + 9.41 * x2 + 8.96 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0 + 5 * x1 >= 21)
    model.addConstr(x0 + 14 * x2 >= 39)
    model.addConstr(5 * x1 + 14 * x2 + x3 >= 45)
    model.addConstr(x0 + 5 * x1 + 14 * x2 + x3 >= 45)
    model.addConstr(6 * x1 + 4 * x3 >= 13)
    model.addConstr(6 * x2 + 4 * x3 >= 25)
    model.addConstr(6 * x1 + 6 * x2 >= 11)
    model.addConstr(15 * x0 + 6 * x1 + 6 * x2 + 4 * x3 >= 11)
    model.addConstr(9 * x2 - 4 * x3 >= 0)
    model.addConstr(x0 + 5 * x1 + x3 <= 216)
    model.addConstr(5 * x1 + 14 * x2 + x3 <= 225)
    model.addConstr(x0 + 5 * x1 + 14 * x2 <= 134)
    model.addConstr(15 * x0 + 6 * x1 + 6 * x2 <= 84)
    model.addConstr(6 * x1 + 6 * x2 + 4 * x3 <= 112)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x0.varValue}")
        print(f"Hours worked by Laura: {x1.varValue}")
        print(f"Hours worked by Peggy: {x2.varValue}")
        print(f"Hours worked by John: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
