
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")
john_hours = model.addVar(vtype=GRB.CONTINUOUS, name="john_hours")


# Set objective function
model.setObjective(8.6 * dale_hours * john_hours + 8.47 * john_hours**2 + 3.71 * dale_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * dale_hours**2 + 13 * john_hours**2 >= 22, "computer_competence_rating_min")
model.addConstr(8 * dale_hours + 13 * john_hours >= 22, "computer_competence_rating_linear_min")
model.addConstr(15 * dale_hours + 13 * john_hours >= 39, "dollar_cost_per_hour_min1")  # Redundant
model.addConstr(15 * dale_hours + 13 * john_hours == 39, "dollar_cost_per_hour_min2") # Kept for equality constraint
model.addConstr(2 * dale_hours - john_hours >= 0, "dale_john_hours_relation")
model.addConstr(8 * dale_hours**2 + 13 * john_hours**2 <= 79, "computer_competence_rating_max")
model.addConstr(15 * dale_hours + 13 * john_hours <= 43, "dollar_cost_per_hour_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Dale Hours: %g' % dale_hours.x)
    print('John Hours: %g' % john_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

