
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Dale", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_John")

# Define the objective function
m.setObjective(8.6*x1*x2 + 8.47*x2**2 + 3.71*x1, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(8*x1**2 + 13*x2**2 >= 22)
m.addConstr(8*x1 + 13*x2 >= 22)
m.addConstr(15*x1 + 13*x2 >= 39)
m.addConstr(2*x1 - x2 >= 0)
m.addConstr(8*x1**2 + 13*x2**2 <= 79)
m.addConstr(15*x1 + 13*x2 <= 43)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x1.varValue}")
    print(f"Hours worked by John: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
