
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
hot_dogs = m.addVar(vtype=GRB.CONTINUOUS, name="hot_dogs")
cornichons = m.addVar(vtype=GRB.CONTINUOUS, name="cornichons")
strawberries = m.addVar(vtype=GRB.CONTINUOUS, name="strawberries")


# Set objective function
m.setObjective(7 * hot_dogs + 6 * cornichons + 8 * strawberries, GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * hot_dogs + 9 * strawberries >= 53, "protein_hot_dogs_strawberries")
m.addConstr(3 * cornichons + 9 * strawberries >= 34, "protein_cornichons_strawberries")
m.addConstr(22 * hot_dogs + 3 * cornichons >= 35, "protein_hot_dogs_cornichons")
m.addConstr(22 * hot_dogs + 3 * cornichons + 9 * strawberries >= 35, "protein_all")
m.addConstr(23 * hot_dogs + 19 * cornichons >= 26, "fat_hot_dogs_cornichons")
m.addConstr(23 * hot_dogs + 7 * strawberries >= 46, "fat_hot_dogs_strawberries")
m.addConstr(23 * hot_dogs + 19 * cornichons + 7 * strawberries >= 46, "fat_all")
m.addConstr(7 * hot_dogs - 6 * strawberries >= 0, "hot_dogs_strawberries_relation")
m.addConstr(5 * hot_dogs - 3 * cornichons >= 0, "hot_dogs_cornichons_relation")
m.addConstr(22 * hot_dogs + 9 * strawberries <= 127, "protein_hot_dogs_strawberries_upper")
m.addConstr(3 * cornichons + 9 * strawberries <= 94, "protein_cornichons_strawberries_upper")
m.addConstr(22 * hot_dogs + 3 * cornichons + 9 * strawberries <= 116, "protein_all_upper")
m.addConstr(23 * hot_dogs + 19 * cornichons + 7 * strawberries <= 96, "fat_all_upper")

# Resource constraints
m.addConstr(22 * hot_dogs + 23 * hot_dogs <= 207, "resource_r0")
m.addConstr(19 * cornichons + 7 * strawberries <= 139, "resource_r1")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('hot_dogs:', hot_dogs.x)
    print('cornichons:', cornichons.x)
    print('strawberries:', strawberries.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

