
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ham_sandwiches")
black_beans = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="black_beans")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")


# Set objective function
m.setObjective(5*oreos + 7*fruit_salads + 8*ham_sandwiches + 2*black_beans + 2*hot_dogs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17*oreos + 2*fruit_salads + 25*ham_sandwiches + 3*black_beans + 19*hot_dogs <= 692, "c0")
m.addConstr(14*oreos + 19*fruit_salads + 15*ham_sandwiches + 11*black_beans + 1*hot_dogs <= 596, "c1")
m.addConstr(17*oreos + 3*black_beans >= 72, "c2")
m.addConstr(3*black_beans + 19*hot_dogs >= 131, "c3")
m.addConstr(17*oreos + 19*hot_dogs >= 105, "c4")
m.addConstr(2*fruit_salads + 3*black_beans >= 122, "c5")
m.addConstr(25*ham_sandwiches + 3*black_beans >= 117, "c6")
m.addConstr(17*oreos + 25*ham_sandwiches >= 111, "c7")
m.addConstr(2*fruit_salads + 19*hot_dogs >= 68, "c8")
m.addConstr(17*oreos + 2*fruit_salads >= 82, "c9")
m.addConstr(17*oreos + 2*fruit_salads + 3*black_beans >= 77, "c10")
m.addConstr(17*oreos + 2*fruit_salads + 25*ham_sandwiches + 3*black_beans + 19*hot_dogs >= 77, "c11")

# ... (rest of the constraints - see full code below)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

