
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="orange_trees")
    x1 = m.addVar(vtype=GRB.INTEGER, name="zucchini_vines")
    x2 = m.addVar(vtype=GRB.INTEGER, name="agave")


    # Set objective function
    m.setObjective(8*x0**2 + 8*x0*x1 + 8*x0*x2 + 2*x1**2 + 7*x1*x2 + 3*x2**2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(23*x0 + 17*x2 >= 61, "c0")
    m.addConstr(9**2*x1**2 + 17**2*x2**2 >= 22, "c1")
    m.addConstr(23*x0 + 9*x1 + 17*x2 >= 30, "c2")
    m.addConstr(23**2*x0**2 + 17**2*x2**2 <= 145, "c3")
    m.addConstr(23*x0 + 9*x1 + 17*x2 <= 145, "c4")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Orange Trees:', x0.x)
        print('Zucchini Vines:', x1.x)
        print('Agave:', x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
