
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="orange_trees", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="zucchini_vines", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="agave", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8*x1**2 + 8*x1*x2 + 8*x1*x3 + 2*x2**2 + 7*x2*x3 + 3*x3**2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(23*x1 + 17*x3 >= 61)
    model.addConstr(81*x2**2 + 289*x3**2 >= 22)
    model.addConstr(23*x1 + 9*x2 + 17*x3 >= 30)
    model.addConstr(529*x1**2 + 289*x3**2 <= 145)
    model.addConstr(23*x1 + 9*x2 + 17*x3 <= 145)

    # Non-negativity constraints are implicitly handled by Gurobi for integer variables

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Orange Trees: ", x1.varValue)
        print("Zucchini Vines: ", x2.varValue)
        print("Agave: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
