
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_John")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_George")


    # Set objective function
    m.setObjective(3*x0 + 1*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14*x0 + 17*x1 >= 39, "c0")
    m.addConstr(14*x0 + 4*x1 >= 21, "c1")
    m.addConstr(11*x0 + 20*x1 >= 66, "c2")
    m.addConstr(2*x0 - 7*x1 >= 0, "c3")
    m.addConstr(14*x0 + 17*x1 <= 106, "c4")
    m.addConstr(14*x0 + 4*x1 <= 55, "c5")
    m.addConstr(11*x0 + 20*x1 <= 131, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

