
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="hours_worked_by_John")
x1 = m.addVar(lb=0, name="hours_worked_by_George")

# Set the objective function
m.setObjective(3*x0 + x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(14*x0 + 17*x1 >= 39, "productivity_rating_constraint")
m.addConstr(14*x0 + 4*x1 >= 21, "computer_competence_rating_constraint")
m.addConstr(11*x0 + 20*x1 >= 66, "organization_score_constraint")
m.addConstr(2*x0 - 7*x1 >= 0, "additional_linear_constraint")
m.addConstr(14*x0 + 17*x1 <= 106, "upper_bound_productivity_rating_constraint")
m.addConstr(14*x0 + 4*x1 <= 55, "upper_bound_computer_competence_rating_constraint")
m.addConstr(11*x0 + 20*x1 <= 131, "upper_bound_organization_score_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by John: {x0.x}")
    print(f"Hours worked by George: {x1.x}")
else:
    print("No optimal solution found")
