
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='hours_worked_by_John', lb=0)  # Assuming hours cannot be negative
x2 = m.addVar(name='hours_worked_by_George', lb=0)  # Assuming hours cannot be negative

# Define the objective function
m.setObjective(3 * x1 + x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * x1 + 17 * x2 >= 39)
m.addConstr(14 * x1 + 4 * x2 >= 21)
m.addConstr(11 * x1 + 20 * x2 >= 66)
m.addConstr(2 * x1 - 7 * x2 >= 0)
m.addConstr(14 * x1 + 17 * x2 <= 106)
m.addConstr(14 * x1 + 4 * x2 <= 55)
m.addConstr(11 * x1 + 20 * x2 <= 131)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('Hours worked by John: ', x1.varValue)
    print('Hours worked by George: ', x2.varValue)
else:
    print('The model is infeasible')
