
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B1
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B5
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # grams of fat
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin C


# Set objective function
m.setObjective(7.92*x0 + 4.9*x1 + 7.67*x2 + 3.68*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 5*x2 + 6*x3 >= 44)
m.addConstr(5*x0 + 5*x1 + 5*x2 >= 44)
m.addConstr(5*x0 + 5*x1 + 6*x3 >= 44)
m.addConstr(5*x0 + 5*x2 + 6*x3 >= 44)
m.addConstr(5*x1 + 5*x2 + 6*x3 >= 41)
m.addConstr(5*x0 + 5*x1 + 5*x2 >= 41)
m.addConstr(5*x0 + 5*x1 + 6*x3 >= 41)
m.addConstr(5*x0 + 5*x2 + 6*x3 >= 41)
m.addConstr(5*x1 + 5*x2 + 6*x3 >= 56)
m.addConstr(5*x0 + 5*x1 + 5*x2 >= 56)
m.addConstr(5*x0 + 5*x1 + 6*x3 >= 56)
m.addConstr(5*x0 + 5*x2 + 6*x3 >= 56)
m.addConstr(14*x1 + 6*x3 >= 8)
m.addConstr(14*x1 + 2*x2 >= 10)
m.addConstr(2*x2 + 6*x3 >= 4)
m.addConstr(4*x1 + 8*x2 >= 45)
m.addConstr(13*x0 + 4*x1 >= 25)
m.addConstr(13*x0 + 8*x2 + 11*x3 >= 29)
m.addConstr(13*x0 + 4*x1 + 8*x2 >= 29)
m.addConstr(13*x0 + 8*x2 + 11*x3 >= 47)
m.addConstr(13*x0 + 4*x1 + 8*x2 >= 47)
m.addConstr(5*x0 + 6*x3 <= 211)
m.addConstr(5*x0 + 5*x1 <= 238)
m.addConstr(5*x0 + 5*x1 + 5*x2 + 6*x3 <= 238)
m.addConstr(7*x1 + 10*x2 <= 47)
m.addConstr(7*x1 + 12*x3 <= 110)
m.addConstr(8*x0 + 10*x2 <= 79)
m.addConstr(8*x0 + 7*x1 + 10*x2 + 12*x3 <= 79)
m.addConstr(2*x2 + 6*x3 <= 13)
m.addConstr(9*x0 + 2*x2 <= 46)
m.addConstr(14*x1 + 6*x3 <= 37)
m.addConstr(9*x0 + 6*x3 <= 31)
m.addConstr(9*x0 + 14*x1 + 2*x2 + 6*x3 <= 31)
m.addConstr(13*x0 + 4*x1 <= 80)
m.addConstr(4*x1 + 8*x2 + 11*x3 <= 176)
m.addConstr(13*x0 + 4*x1 + 8*x2 <= 222)
m.addConstr(13*x0 + 4*x1 + 8*x2 + 11*x3 <= 222)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

