
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
    john = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="john")
    george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
    hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")

    # Set objective function
    model.setObjective(3.4 * laura + 3.75 * john + 9.58 * george + 9.08 * hank, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(28 * john + 6 * hank >= 45, "c1")
    model.addConstr(28 * laura + 8 * john >= 55, "c2")
    model.addConstr(28 * laura + 8 * john + 27 * george + 6 * hank >= 55, "c3")
    model.addConstr(4 * laura + 2 * john >= 30, "c4")
    model.addConstr(4 * laura + 11 * hank >= 44, "c5")
    model.addConstr(6 * george + 11 * hank >= 31, "c6")
    model.addConstr(4 * laura + 6 * george >= 30, "c7")
    model.addConstr(4 * laura + 6 * george + 11 * hank >= 32, "c8")
    model.addConstr(4 * laura + 2 * john + 11 * hank >= 32, "c9")
    model.addConstr(4 * laura + 6 * george + 11 * hank >= 45, "c10")
    model.addConstr(4 * laura + 2 * john + 11 * hank >= 45, "c11")
    model.addConstr(4 * laura + 2 * john + 6 * george + 11 * hank >= 45, "c12")
    model.addConstr(-10 * laura + 3 * hank >= 0, "c13")
    model.addConstr(28 * laura + 6 * hank <= 261, "c14")
    model.addConstr(27 * george + 6 * hank <= 273, "c15")
    model.addConstr(28 * laura + 8 * john <= 203, "c16")
    model.addConstr(2 * john + 6 * george <= 93, "c17")
    model.addConstr(4 * laura + 11 * hank <= 103, "c18")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Other model status')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
