
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Laura
    x1 = model.addVar(name="x1", lb=0, integrality=gurobi.GRB.INTEGER)  # hours worked by John
    x2 = model.addVar(name="x2", lb=0)  # hours worked by George
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Hank

    # Objective function
    model.setObjective(3.4 * x0 + 3.75 * x1 + 9.58 * x2 + 9.08 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * x1 + 6 * x3 >= 45)
    model.addConstr(28 * x0 + 8 * x1 >= 55)
    model.addConstr(28 * x0 + 8 * x1 + 27 * x2 + 6 * x3 >= 55)
    model.addConstr(4 * x0 + 2 * x1 >= 30)
    model.addConstr(4 * x0 + 11 * x3 >= 44)
    model.addConstr(6 * x2 + 11 * x3 >= 31)
    model.addConstr(4 * x0 + 6 * x2 >= 30)
    model.addConstr(4 * x0 + 6 * x2 + 11 * x3 >= 32)
    model.addConstr(4 * x0 + 2 * x1 + 11 * x3 >= 32)
    model.addConstr(4 * x0 + 6 * x2 + 11 * x3 >= 45)
    model.addConstr(4 * x0 + 2 * x1 + 11 * x3 >= 45)
    model.addConstr(4 * x0 + 2 * x1 + 6 * x2 + 11 * x3 >= 45)
    model.addConstr(-10 * x0 + 3 * x3 >= 0)
    model.addConstr(28 * x0 + 6 * x3 <= 261)
    model.addConstr(27 * x2 + 6 * x3 <= 273)
    model.addConstr(28 * x0 + 8 * x1 <= 203)
    model.addConstr(2 * x1 + 6 * x2 <= 93)
    model.addConstr(4 * x0 + 11 * x3 <= 103)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Laura: {x0.varValue}")
        print(f"Hours worked by John: {x1.varValue}")
        print(f"Hours worked by George: {x2.varValue}")
        print(f"Hours worked by Hank: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
